﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Handel.Forms" %>
<%@ Import Namespace="Soneta.Handel.Config" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Collections.ObjectModel" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Stany magazynowe</title>
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">

    <script runat="server">
                		       		
        public sealed class Parameters : ContextBase {
            private FromTo _okres;

            [Priority( 20 )]
            [Caption( "Okres" )]
            [DefaultWidth( 24 )]
            public FromTo DataStanu {
                get {
                    return this._okres;
                }
                set {
                    this._okres = value;
                    base.OnChanged( EventArgs.Empty );
                }
            }

            public Parameters( Context context )
                : base( context ) {
                FromTo ft;
                Magazyn m;
                OkresMagazynowy om;
                DokumentyParams dp;
                DokHandloweViewInfo.WParams wp;
                UstawieniaHandloweWorker uh = context != null ? new UstawieniaHandloweWorker( context.Session ) : null;
                //
                // _okres
                //
                this._okres = new FromTo(Date.Today, Date.Today);

            }           
        }

        private Parameters _params;

        [Context]
        public Parameters Params {
            get { return this._params; }
            set { this._params = value; }
        }
        ObrotyParams obrotyParams = null;
        
        private void dc_ContextLoad( object sender, EventArgs e ) {
            DataContext dc = sender as DataContext;
            if( dc != null ) {
                obrotyParams = (Soneta.Magazyny.ObrotyParams)dc[typeof(Soneta.Magazyny.ObrotyParams)];
                checkObrotyPars(obrotyParams);
                obrotyParams.OkresCzasu = _params.DataStanu;
                ReportHeader.Title += WydrukiTools.WydrukiStanyMagazynoweLista.FormatMagazyny(obrotyParams.Magazyny);
                ReportHeader.DataContext = dc;
            }
        }

        Quantity roznica = Quantity.Zero;
        Quantity przedIlośćMagazynu = Quantity.Zero;
        Quantity poIlośćMagazynu = Quantity.Zero;
        void Grid_OnBeforeRow( object sender, RowEventArgs args ) {
            Towar towar = ( Towar ) args.Row;

            StanMagazynuWorker przed = null;
            StanMagazynuWorker po = null;

            foreach( Magazyn magazyn in obrotyParams.Magazyny ) {
                przed = new StanMagazynuWorker();
                przed.Towar = towar;
                przed.Data = _params.DataStanu.Equals( FromTo.All ) || _params.DataStanu.Equals( FromTo.Empty ) ? _params.DataStanu.From : _params.DataStanu.From - 1;
                przed.Magazyn = magazyn;

                po = new StanMagazynuWorker();
                po.Towar = towar;
                po.Data = _params.DataStanu.To;
                po.Magazyn = magazyn;

                przedIlośćMagazynu += przed.StanMagazynu;
                poIlośćMagazynu += po.StanMagazynu;

                roznica += po.StanMagazynu - przed.StanMagazynu;
            }

            if( przedIlośćMagazynu.Equals( Quantity.Zero ) && poIlośćMagazynu.Equals( Quantity.Zero) )
                args.VisibleRow = false;

            StanPoczatkowyColumn.EditValue = przedIlośćMagazynu;
            StanKoncowyColumn.EditValue = poIlośćMagazynu;

            if( roznica != Quantity.Zero )
                if( roznica > Quantity.Zero ) 
                    PrzychodColumn.EditValue = roznica; 
                else
                    RozchodColumn.EditValue = roznica;

            roznica = Quantity.Zero;
            przedIlośćMagazynu = Quantity.Zero;
            poIlośćMagazynu = Quantity.Zero;
        }

        private void checkObrotyPars(ObrotyParams pars) {
            if (pars == null)
                throw new ArgumentNullException("ObrotyParams pars");
            if (pars.Magazyny == null || (pars.Magazyny != null && pars.Magazyny.Length == 0))
                throw new InvalidOperationException("Wymagane jest wybranie przynajmniej jednego magazynu.");
        }
        
    </script>

</head>
<body>
    <form method="post" runat="server">
    <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
    <eb:ReportHeader id="ReportHeader" title="Stany magazynowe|</STRONG>Okres magazynowy:<STRONG> {0}|</STRONG>Dostawca:<STRONG> {2}|</STRONG>Okres czasu:<STRONG> {3:b}|Magazyny:<STRONG> </STRONG>"
        runat="server" DataMember0="ObrotyParams.Okres" DataMember1="ObrotyParams.Magazyn"
        DataMember2="ObrotyParams.Dostawca" DataMember3="ObrotyParams.OkresCzasu">
    </eb:ReportHeader>
    <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Handel" OnBeforeRow="Grid_OnBeforeRow">
        <Columns>
            <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server"
                EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Left" DataMember="Kod" Caption="Towar~Kod" EncodeHTML="True"
                runat="server">
            </ea:GridColumn>
            <ea:GridColumn Align="Left" DataMember="Nazwa" Total="Info" Caption="Towar~Nazwa"
                EncodeHTML="True" runat="server">                
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Right" ID="StanPoczatkowyColumn" Total="Sum" Caption="Towar~Stan początkowy" 
                EncodeHTML="True" runat="server">                
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Right" ID="PrzychodColumn" Total="Sum" Caption="Towar~Przychód - Rozchód (+)"
                EncodeHTML="True" runat="server">                
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Right" ID="RozchodColumn" Total="Sum" Caption="Towar~Przychód - Rozchód (-)"
                EncodeHTML="True" runat="server">                
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Right" ID="StanKoncowyColumn" Total="Sum" Caption="Towar~Stan końcowy"
                EncodeHTML="True" runat="server">                
            </ea:GridColumn>
        </Columns>
    </ea:Grid>
    <eb:ReportFooter id="ReportFooter" runat="server" PrintDate="true" PrintTime="true">
    </eb:ReportFooter>
    </form>
</body>
</html>

